#include "objectpair.h"
#include <algorithm>
#include <iostream>

ObjectPair::ObjectPair(Object object1, Object object2)
{
     this->object1 = object1.data;
     this->object2 = object2.data;

     final_score = min(object1.score, object2.score)*countSim(object1.data.size(), object2.data.size(),
                                                              countOverlap(object1.data, object2.data));
}

ObjectPair::ObjectPair(Object object1, Object object2, int overlap)
{
     this->object1 = object1.data;
     this->object2 = object2.data;

     final_score = min(object1.score, object2.score)*countSim(object1.data.size(), object2.data.size(), overlap);
}

bool ObjectPair::operator < (const ObjectPair& pair) const
{
    return (final_score > pair.final_score);
}

bool ObjectPair::operator == (const ObjectPair& pair) const
{
    bool result = true;
    if (final_score != pair.final_score) return false;
    else {
        for (int i = 0; i <= object1.size() - 1; i++)
            if (object1[i] != pair.object1[i]) {
                result = false;
                break;
            }
        for (int i = 0; i <= object2.size() - 1; i++)
            if (object2[i] != pair.object2[i]) {
                result = false;
                break;
            }
    }
    return result;
}

double ObjectPair::countSim(int object1_size, int object2_size, int overlap)
{
    return double(overlap)/(object1_size + object2_size - overlap); //Jaccard similarity
}

int ObjectPair::countOverlap(vector<Token>& object1, vector<Token>& object2)
{
    int count1 = 0;
    int count2 = 0;
    int overlap = 0;

    while (count1 <= object1.size() - 1 && count2 <= object2.size() - 1) {
        if (object1[count1] < object2[count2])
            count1++;
        else if (object2[count2] < object1[count1])
            count2++;
        else {
            if (object1[count1] == object2[count2])
                overlap++;
            count1++;
            count2++;
        }
    }

    return overlap;
}
